/**
 * epiClock Rendering Engines
 *
 * Copyright (c) 2008 Eric Garside (http://eric.garside.name)
 * Dual licensed under:
 * 	MIT: http://www.opensource.org/licenses/mit-license.php
 *	GPLv3: http://www.opensource.org/licenses/gpl-3.0.html
 */


/**
 * Flip Clock - A retro flip clock!
 *
 * Example useage:
 *	var options = $.extend({}, flip_clock, { Your Configurations Here });
 *	$('#epiClock').epiclock(options);
 */
var flip_clock = {format: 'H{<img src="flip_clock/sep.gif"/>}i', onRender:function(e, val){
		var digits = val.substring(1) == 'm' ? [val] : val.split('').reverse();
		var	last = e.data('last');
		var	cmp = last ? last.split('').reverse() : [];
		var	img = $.makeArray(e.children('img')).reverse();
		var	prefix = last ? 'd' : 's';
		if (prefix == 'd') {
		    d = val-last;
				x = Math.abs(d);
				if ((x > 1) && (x!=10))
				    prefix = 's';
				else
				if (d > 0)
				    prefix = 'd';
				else
				    prefix = 'u';
		}

		$.each(digits, function(i){
			var x = this+'',i;
			if (x == cmp[i]) return;
			i = img[i] || $('<img/>').prependTo(e);
			i = $(i);
			i.attr({src: 'flip_clock/' + prefix + x + '.gif', ref: 'flip_clock/s' + x + '.gif'});
			setTimeout(function(){i.attr('src', i.attr('ref'))}, 350)
		})
	}
}
